---
title: IDS · Cloudflare Magic Firewall docs
description: Cloudflare's Intrusion Detection System (IDS) is an Advanced Magic
  Firewall feature you can use to actively monitor for a wide range of known
  threat signatures in your traffic. An IDS expands the security coverage of a
  firewall to analyze traffic against a broader threat database, detecting a
  variety of sophisticated attacks such as ransomware, data exfiltration, and
  network scanning based on signatures or “fingerprints” in network traffic.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-firewall/about/ids/
  md: https://developers.cloudflare.com/magic-firewall/about/ids/index.md
---

Cloudflare's Intrusion Detection System (IDS) is an Advanced Magic Firewall feature you can use to actively monitor for a wide range of known threat signatures in your traffic. An IDS expands the security coverage of a firewall to analyze traffic against a broader threat database, detecting a variety of sophisticated attacks such as ransomware, data exfiltration, and network scanning based on signatures or “fingerprints” in network traffic.

With Cloudflare’s global anycast network, you get:

* Cloudflare’s entire global network capacity is now the capacity of your IDS.
* Built in redundancy and failover. Every server runs Cloudflare's IDS software, and traffic is automatically attracted to the closest network location to its source.
* Continuous deployment for improvements to Cloudflare’s IDS capabilities.

Refer to [Enable IDS](https://developers.cloudflare.com/magic-firewall/how-to/enable-ids/) for more information on enabling IDS and creating new rulesets. After IDS is enabled, your traffic will be scanned to find malicious traffic. The detections are logged to destinations that can be configured from the dashboard. Refer to [Use Logpush with IDS](https://developers.cloudflare.com/magic-firewall/how-to/use-logpush-with-ids/) for instructions on configuring a destination to receive the detections. Additionally, all traffic that is analyzed can be accessed via [network analytics](https://developers.cloudflare.com/analytics/network-analytics/). Refer to [GraphQL Analytics](https://developers.cloudflare.com/magic-firewall/tutorials/graphql-analytics/) to query the analytics data.
